package parser.visitor;

import parser.*;

/**
 * Algo to check the semantics of a parsed XML file.  
 * Checks if the start tags match their end tags.
 * A simple Id token returns true.
 * An MTSymbol token returns true.
 * In general, valid XML produces a sequence of tokens as per the 
 * TaggedElt production rule: TaggedElt ::= < Id > AXML </ Id > 
 * TaggedElt is a chain of 6 SequenceTokens: 
 * below, each [A, B] is a binary SequenceSymbol: 
 * [<, [Id, [>, [AXML, [</, [Id, >]]]]]]  
 * Note that AXML is always a Sequence whose last token is MTSymbol.
 */
public class CheckMatchingTagsAlgo implements IGramTypeVisitor<Boolean, Object> {
  public static final CheckMatchingTagsAlgo Singleton = new CheckMatchingTagsAlgo();
  
  /**
   * Utility algo to jump to the n'th SequenceSymbol in a chain.
   */
  private CheckNthSequenceAlgo nthSeq = CheckNthSequenceAlgo.Singleton;
  
  /**
   * Utility algo to process every element in a chain of SequenceTokens
   */
  private  ACheckTagsAlgo<IGramTypeVisitor<Boolean, Object>> processList = ProcessListAlgo.Singleton;
  
  
  private CheckMatchingTagsAlgo() {}
  
  public Boolean mtCase(MTSymbol host, Object... inps) {
    return true;
  }
  public Boolean termCase(TerminalSymbol host, Object... inps) {
    return true;
  }
  public Boolean seqCase(SequenceSymbol host, Object... inps) {
    return  host.getSymbol2().execute(nthSeq, 0, new ACheckTagsAlgo<Object>(){
      public Boolean seqCase(SequenceSymbol h1, Object... inps) {            
        final String startTag = h1.getSymbol1().toString();
        return h1.getSymbol2().execute(nthSeq, 1, new ACheckTagsAlgo<Object>(){
          public Boolean seqCase(SequenceSymbol h2, Object... inps) {            
            boolean rr = h2.getSymbol1().execute(processList, CheckMatchingTagsAlgo.this) ;
            return rr && h2.getSymbol2().execute(nthSeq, 1, new ACheckTagsAlgo<Object>(){
              public Boolean seqCase(SequenceSymbol h3, Object... inps) {            
                String endTag = h3.getSymbol1().toString();
                System.out.println("startTag = "+startTag+"  endTag = "+endTag);
                return startTag.equals(endTag);
              }
            });
          }
        });
      }
    });
  }
}
